from byubit import Bit


def is_frog(bit):
    """Square is a frog if it is green and above a black square"""
    return bit.is_on_green() and not bit.can_move_right()


@Bit.worlds('frog-on-rock')
@Bit.pictures()
def go(bit):
    while bit.can_move_front():
        bit.move()
        if is_frog(bit):
            bit.paint('white')


if __name__ == '__main__':
    go(Bit.new_bit)
