def empty_grid(num_rows, num_columns, value=None):
    """
    Create an empty grid. <num_rows> is the number
    of rows in the grid. <num_columns> is the number
    of columns in the grid. Fill the grid with None or with
    whatever value the caller supplies in <value>.
    """
    # create an empty grid
    new_grid = []
    # keep going until we have created all the rows
    while len(new_grid) < num_rows:
        new_row = []
        # keep going until we have all the columns we need
        while len(new_row) < num_columns:
            # append an item for this column
            new_row.append(value)
        # now that we have a full row, append the row
        new_grid.append(new_row)
    return new_grid


def print_grid(grid):
    """
    Print all the items in the grid, so that it looks like a grid
    """
    # go through all the rows
    for row in grid:
        for item in row:
            # print the item, but with a space after it, not a newline
            print(item, end=' ')
        print()


def main():
    grid = empty_grid(3, 5, value='.')

    print_grid(grid)
    print()

    grid[0][4] = '*'
    grid[1][2] = '?'
    grid[2][1] = '!'

    print_grid(grid)


if __name__ == '__main__':
    main()
