def readgrid(filename):
    '''
    Read a grid from the file given by <filename> and return
    a grid object. The file should have all of the grid items
    separated by a space in each row.
    '''
    # read all of the lines of the file given
    # by <filename>
    with open(filename) as file:
        lines = file.readlines()

    # create an empty grid
    grid = []

    # for each line
    for line in lines:
        # split the line into a list, based on spaces
        # append that list as the next row in the grid
        grid.append(line.split())

    # return the grid
    return grid


def print_grid(grid):
    """
    Print all the items in the grid, so that it looks like a grid
    """
    # go through all the rows
    for row in grid:
        for item in row:
            # print the item, but with a space after it, not a newline
            print(item, end=' ')
        print()


if __name__ == '__main__':
    grid = readgrid('grid_example.txt')
    print_grid(grid)
