# Solution
from byubit import Bit


def fill_column_with_water_and_return(bit):
    bit.turn_right()
    # fill pool
    while bit.can_move_front():
        bit.move()
        bit.paint('blue')
    # turn around
    bit.turn_right()
    bit.turn_right()
    # return
    while bit.is_on_blue():
        bit.move()
    # face right
    bit.turn_right()
    bit.move()


def fill_pool(bit):
    """
    Bit starts at the upper left, facing right, above an empty pool
    Bit finishes at the first corner past the upper right of the pool, facing right
    """
    while bit.can_move_right():
        fill_column_with_water_and_return(bit)


def draw_flower(bit):
    """
    Bit starts and ends at the base of the flower facing right
    """
    bit.turn_left()
    bit.paint('green')
    bit.move()
    bit.paint('green')
    bit.move()
    bit.paint('red')
    bit.turn_left()
    bit.move()
    bit.paint('red')
    bit.turn_right()
    bit.move()
    bit.turn_right()
    bit.move()
    bit.paint('red')
    bit.move()
    bit.turn_right()
    bit.move()
    bit.paint('red')
    bit.turn_right()
    bit.move()
    bit.turn_left()
    bit.move()
    bit.move()
    bit.turn_left()


def pond_and_flower(bit):
    """
    Bit starts facing right above an empty pool
    Bit needs to fill the pool and draw the flower
    Bit will end facing right at the base of the flower
    """
    fill_pool(bit)
    draw_flower(bit)


@Bit.worlds('blossoms', 'blossoms2')
def go(bit):
    while bit.can_move_front():
        bit.move()
        if bit.can_move_right():
            pond_and_flower(bit)


if __name__ == '__main__':
    go(Bit.new_bit)
