# Solution
from byubit import Bit


def surround_block(bit):
    """
    Bit starts above the upper-left of the block facing right.
    Bit paints the sides of the block green.
    Bit ends at the same place, facing right
    """
    while not bit.is_on_green():
        bit.paint('green')
        bit.move()
        if bit.can_move_right():
            # we are in a corner
            bit.turn_right()
            bit.move()


def move_past_block(bit):
    """
    Bit starts above the upper-left of the block, facing right.
    Bit ends one square past the upper-right of the block, facing right.
    """

    while not bit.can_move_right():
        bit.move()


@Bit.worlds('surround', 'surround2')
def run(bit):
    while bit.can_move_front():
        if not bit.can_move_right():
            surround_block(bit)
            move_past_block(bit)
        else:
            bit.move()


if __name__ == '__main__':
    run(Bit.new_bit)
