from byubit import Bit
import byubit
byubit.bit.MAX_STEP_COUNT = 10_000


def go_paint(bit, color):
    """Paint `color` until blocked in front"""
    while bit.can_move_front():
        bit.paint(color)
        bit.move()


def run(bit, how_many):
    """Move bit `how_many` squares"""
    if how_many > 0:
        bit.move()
        run(bit, how_many - 1)


def paint_many(bit, color, how_many):
    """Paint `color` and move `how_many` times"""
    if how_many > 0:
        bit.paint(color)
        bit.move()
        paint_many(bit, color, how_many - 1)


def paint_to(bit, color, ending_color):
    """Paint `color` until you reach `ending_color`"""
    while bit.get_color() != ending_color:
        bit.paint(color)
        bit.move()


def box(bit, color, size):
    """
    Draws a 3x3 box of the specified color
    Bit starts and ends in the same position and orientation
    Bit expects that the starting square is not already the specified color
    """
    while bit.get_color() != color:
        paint_many(bit, color, size)
        bit.turn_left()


def turn_around(bit):
    bit.turn_left()
    bit.turn_left()


def go(bit):
    while bit.can_move_front():
        bit.move()


def column(bit, color):
    bit.turn_left()
    go_paint(bit, color)
    turn_around(bit)
    go_paint(bit, color)
    bit.turn_left()


def fill(bit, color):
    column(bit, color)
    while bit.can_move_front():
        bit.move()
        column(bit, color)


def tree(bit, color):
    bit.turn_left()
    paint_many(bit, 'green', 8)
    bit.move()
    bit.paint('yellow')
    bit.turn_left()
    bit.move()
    bit.turn_left()
    bit.move()
    bit.turn_left()
    box(bit, color, 2)
    bit.turn_right()
    run(bit, 3)
    bit.turn_left()
    paint_many(bit, 'green', 2)
    bit.paint('green')
    bit.turn_right()
    run(bit, 5)
    bit.turn_left()
    bit.move()


@Bit.empty_world(30, 20)
@Bit.pictures(ext='svg', title='DaVinci', name='davinci')
def draw(bit):
    fill(bit, 'blue')
    turn_around(bit)
    go_paint(bit, 'green')
    bit.paint('green')
    turn_around(bit)
    run(bit, 5)
    tree(bit, 'red')
    run(bit, 4)
    tree(bit, 'purple')
    run(bit, 4)
    tree(bit, 'orange')
    run(bit, 5)
    tree(bit, 'red')
    bit.turn_left()
    run(bit, 15)
    bit.turn_left()
    paint_many(bit, None, 8)
    run(bit, 5)
    paint_many(bit, None, 6)
    run(bit, 2)
    bit.turn_left()
    bit.move()
    bit.turn_left()
    paint_many(bit, None, 8)
    run(bit, 5)
    paint_many(bit, None, 6)
    go(bit)
    bit.turn_right()
    go(bit)
    bit.turn_left()


if __name__ == '__main__':
    draw(Bit.new_bit)
