# Solution
from byubit import Bit


def go_back(bit):
    bit.turn_right()
    bit.turn_right()
    while bit.can_move_front():
        bit.move()
    bit.turn_left()


def make_flower(bit, color):
    bit.turn_left()
    bit.move()
    bit.move()
    bit.paint(color)
    go_back(bit)


def find_and_plant_flower(bit, color):
    bit.paint('white')
    # get to flower
    while not bit.is_on_green():
        bit.move()
    # make flower
    make_flower(bit, color)


@Bit.worlds('flowers1', 'flowers2')
def run(bit):
    while bit.can_move_front():
        bit.move()
        if not bit.is_on_white():
            color = bit.get_color()
            find_and_plant_flower(bit, color)


if __name__ == '__main__':
    run(Bit.new_bit)
