# Solution 
from byubit import Bit


def turn(bit):
    bit.turn_left()
    bit.turn_left()


def go(bit):
    while bit.can_move_front():
        bit.move()


def fill_line(bit):
    color = bit.get_color()
    bit.move()
    while bit.get_color() != color:
        bit.paint(color)
        bit.move()


def do_row(bit):
    bit.turn_right()
    while bit.is_on_white():
        bit.move()
    fill_line(bit)
    turn(bit)
    go(bit)
    bit.turn_right()


@Bit.worlds('lines')
def run(bit):
    bit.turn_left()
    do_row(bit)
    while bit.can_move_front():
        bit.move()
        do_row(bit)
    turn(bit)
    go(bit)
    bit.turn_left()


if __name__ == '__main__':
    run(Bit.new_bit)
