def ratings_for_flavor(ratings, requested_flavor):
    new_ratings = []
    for flavor, score in ratings:
        if flavor == requested_flavor:
            new_ratings.append((flavor, score))

    return new_ratings


def get_average(ratings):
    total = 0
    for flavor, score in ratings:
        total = total + score
    return round(total / len(ratings), 1)


def main():
    ratings = [('chocolate', 10), ('vanilla', 8.5), ('huckleberry', 6),
               ('chocolate', 9), ('banana nut', 9.3), ('vanilla', 7.5),
               ('huckleberry', 9.3), ('banana nut', 7.5), ('chocolate', 8),
               ('chocolate', 8), ('banana nut', 10), ('vanilla', 4.1),
               ('chocolate', 10), ('huckleberry', 10), ('vanilla', 10)]
    flavors_to_report_on = ['chocolate', 'banana nut', 'vanilla']
    for flavor in flavors_to_report_on:
        new_ratings = ratings_for_flavor(ratings, flavor)
        average = get_average(new_ratings)
        print(f"The average score for {flavor} is {average}.")


if __name__ == '__main__':
    main()
