def ratings_for_flavor(ratings, requested_flavor):
    new_ratings = []
    for flavor, score in ratings:
        if flavor == requested_flavor:
            new_ratings.append((flavor, score))

    return new_ratings


def get_average(ratings):
    total = 0
    for flavor, score in ratings:
        total = total + score
    return round(total / len(ratings), 1)


def get_rating():
    flavor = input("Enter a flavor: ")
    if flavor == '':
        return None
    rating = float(input("Enter a rating: "))
    return flavor, rating


def get_ratings():
    ratings = []
    print('Enter all the ice cream ratings. Enter an empty flavor to end.')
    while True:
        rating = get_rating()
        if rating is None:
            break
        ratings.append(rating)
    print()
    return ratings


def get_flavors():
    flavors = []
    print("Enter flavors to get info on, ending with a blank line.")
    while True:
        flavor = input("Flavor: ")
        if flavor == '':
            break
        flavors.append(flavor)
    print()
    return flavors


def main():
    ratings = get_ratings()
    flavors = get_flavors()
    for flavor in flavors:
        new_ratings = ratings_for_flavor(ratings, flavor)
        average = get_average(new_ratings)
        print(f"The average score for {flavor} is {average}.")


if __name__ == '__main__':
    main()
