def profit_per_month(house):
    address, purchase_price, after_repair_value, cost_to_repair, project_duration = house
    return profit(house) / project_duration


def profit(house: tuple) -> float:
    address, purchase_price, after_repair_value, cost_to_repair, project_duration = house
    monthly_property_taxes = purchase_price / 1000
    cost_of_sale = 3000
    costs = purchase_price + cost_to_repair + cost_of_sale + (monthly_property_taxes * project_duration)
    return after_repair_value - costs


def print_house(house: tuple):
    address, purchase_price, after_repair_value, cost_to_repair, project_duration = house
    print()
    print(f"Expected profit: ${round(profit(house),2)}")
    # print(f"Expected profit per month: ${round(profit_per_month(house),2)}")
    print()
    print("Address:", address)
    print(f"Purchase price: ${purchase_price}")
    print(f"After repair value: ${after_repair_value}")
    print(f"Cost to repair: ${cost_to_repair}")
    print(f"Project duration: {project_duration} months")


def get_house() -> tuple | None:
    address = input("Address: ")
    if address == "":
        return None
    purchase_price = float(input("Purchase price: "))
    after_repair_value = float(input("After repair value: "))
    cost_to_repair = float(input("Cost to repair: "))
    project_duration = float(input("Project duration: "))
    return address, purchase_price, after_repair_value, cost_to_repair, project_duration


def get_houses() -> list[tuple]:
    houses = []
    while True:
        print()
        house = get_house()
        if house is None:
            break
        houses.append(house)
    return houses


def get_best_house(houses: list[tuple]) -> tuple:
    best_house = None
    best_profit = None
    for house in houses:
        if best_house is None or profit(house) > best_profit:
        # if best_house is None or profit_per_month(house) > best_profit:
            best_house = house
            best_profit = profit(house)
    return best_house


def main():
    houses = get_houses()
    best_house = get_best_house(houses)
    print_house(best_house)


if __name__ == '__main__':
    main()
