def get_rating_info():
    restaurant = input('Restaurant: ')
    if restaurant == '':
        return None
    score = float(input('Rating: '))
    return restaurant, score


def get_ratings():
    ratings = []
    while True:
        rating_info = get_rating_info()
        if rating_info is None:
            break
        ratings.append(rating_info)
    return ratings


def pick_highest(ratings):
    max_score = None
    max_restaurant = None
    for restaurant, score in ratings:
        if max_score is None or max_score < score:
            max_score = score
            max_restaurant = restaurant
    return max_restaurant, max_score


def main():
    ratings = get_ratings()
    restaurant, score = pick_highest(ratings)
    print(f'{restaurant} is rated {score} stars.')


if __name__ == '__main__':
    main()
