def check_password(password):
    if len(password) < 8:
        return False

    # This is true when the password is either all uppercase or all lowercase
    # You can also loop through each character and check if it is uppercase or lowercase
    elif password.upper() == password or password.lower() == password:
        return False

    # This breaks at the first digit that is found
    for character in password:
        if character.isdigit():
            return True  # We can return True here because all other conditions are met

    return False  # If we get here, then there were no digits in the password


def check_password_additional(password):
    """
    This uses booleans to keep track of the password requirements,
    It only loops through the characters once, so it is more efficient than the previous solution
    """
    digit = False
    uppercase = False
    lowercase = False

    if len(password) < 8:
        return False

    for character in password:
        if character.isdigit():
            digit = True
        if character.islower():
            lowercase = True
        if character.isupper():
            uppercase = True

    if digit and lowercase and uppercase:
        return True
    return False


def main():
    print(check_password('password'))
    print(check_password('a87fRPesT'))
    print(check_password('a8P'))
    print(check_password('abFHaprucndPE8'))
    print(check_password('arPReSH!!$@'))
    print(check_password('Password1'))


if __name__ == '__main__':
    main()
