def found_word(text, words):
    """ Return True if one of the words is in the text. Return
    false otherwise.
    - text is a string
    - words is a list of strings
    """
    for word in words:
        if word in text:
            return True
    return False


def chat():
    """ Rules for the chatbot:
    - start with, "Hello! What did you do today?"
    - read input until "goodbye"
    - if input has 'good', 'great', 'fun', or 'amazing'
        - response is "Cool!"
    - if input has 'bad', 'rough', 'sad', or 'terrible'
        - response is "I'm so sorry, how can I help?"
    - otherwise
        - response is "Tell me more."
    """
    print("Hello! What did you do today?")
    good_words = ['good', 'great', 'fun', 'amazing']
    bad_words = ['bad', 'rough', 'sad', 'terrible']
    while True:
        text = input("")
        if text == 'goodbye':
            break
        if found_word(text, good_words):
            response = 'Cool!'
        elif found_word(text, bad_words):
            response = "I'm so sorry, how can I help?"
        else:
            response = "Tell me more."
        print(response)


def main():
    chat()


if __name__ == '__main__':
    main()