import sys


def readlines(filename):
    with open(filename) as file:
        return file.readlines()


def writelines(filename, content):
    with open(filename, 'w') as file:
        file.writelines(content)


def add_blank_lines(lines):
    new_lines = []
    for line in lines:
        line += '\n'
        new_lines.append(line)

    return new_lines


def main(infile, outfile):
    lines = readlines(infile)
    # add blank lines
    lines = add_blank_lines(lines)
    writelines(outfile, lines)


if __name__ == '__main__':
    main(sys.argv[1], sys.argv[2])
