import sys


def readlines(filename):
    with open(filename) as file:
        return file.readlines()


def writelines(filename, content):
    with open(filename, 'w') as file:
        file.writelines(content)


def digit_to_pound(line):
    text = ''
    for character in line:
        if character.isdigit():
            text += '#'
        else:
            text += character

    return text


def replace_digits(lines):
    new_lines = []
    for line in lines:
        line = digit_to_pound(line)
        new_lines.append(line)

    return new_lines


def main(infile, outfile):
    lines = readlines(infile)
    # replace digits with #
    lines = replace_digits(lines)
    writelines(outfile, lines)


if __name__ == '__main__':
    main(sys.argv[1], sys.argv[2])
