import sys


def readlines(filename):
    """ Read a file and return a list of lines. """
    with open(filename) as file:
        return file.readlines()


def group_pokemon(lines, column):
    """
    lines: a list of lines, each line is a comma-separated list of values
    column: an integer column number

    Find all of the Pokemon who have the same value in the given column.

    Return a dictionary that maps the column value to the list of Pokemon.
    For example, if the column is the number 4, then the dictionary will
    map the Pokemon type (water, fire) to a list of Pokemon of that type.
    """
    # create an empty dictionary
    groups = {}
    # go through the lines
    for line in lines:
        # strip white space and then split on comma
        # tokens is a list of strings, one string per column
        tokens = line.strip().split(',')
        # use list indexing to get the key where the type is listed
        # key is now "water" or "fire" or whatever type
        key = tokens[column]
        # get the name of this pokemon
        name = tokens[0]
        # if we haven't seen this type of pokemon before, initialize
        # its count to zero
        if key not in groups:
            groups[key] = []
        # add this pokemon to the list
        groups[key].append(name)
    # return the dictionary
    return groups


def print_groups(groups):
    """ Print a dictionary that maps words to a list of Pokemon . """
    for value, pokemon in groups.items():
        print(f"{value}")
        for name in pokemon:
            print(f"* {name}")


def main(filename, column):
    # read all the lines of the file
    lines = readlines(filename)
    # count the Pokemon of each type
    groups = group_pokemon(lines, column)
    print_groups(groups)


if __name__ == '__main__':
    main(sys.argv[1], int(sys.argv[2]))
