import sys


def readlines(filename):
    with open(filename) as file:
        return file.readlines()
    
    
def read_dict_from_csv(filename):
    """
    The file contains rows like:
    Speaker,AV request
    
    Return a dictionary mapping each speaker to his or her AV request
    """
    data = {}
    lines = readlines(filename)
    for line in lines:
        tokens = line.strip().split(',')
        data[tokens[0]] = tokens[1]
    return data


def invert_assignments(speaker_rooms):
    """
    Return a new dictionary mapping room to speaker
    """
    room_speakers = {}
    for speaker, room in speaker_rooms.items():
        room_speakers[room] = speaker
    return room_speakers


def make_itinerary(desired_speaker_times, room_assignments):
    """
    Input: list of (speaker, time) tuples
    Return a list of (speaker, room, time) tuples
    """
    itinerary = []
    for speaker, time in desired_speaker_times:
        itinerary.append((speaker, room_assignments[speaker], time))
    return itinerary


def make_room_assignments(speakers, rooms):
    """
    Return a dictionary mapping each speaker to a room
    """
    assignments = {}
    for speaker, room in zip(speakers, rooms):
        assignments[speaker] = room
    return assignments


def main(speakers, rooms, desired_lineup, av_request_file):
    room_assignments = make_room_assignments(speakers, rooms)
    print("Speaker room assignments:")
    print(room_assignments)
    print()
    
    print("Itinerary:")
    itinerary = make_itinerary(desired_lineup, room_assignments)
    print(itinerary)
    print()
    
    print("Room-to-speaker assignments:")
    print(invert_assignments(room_assignments))
    print()
    
    print('AV Requests:')
    av_requests = read_dict_from_csv(av_requests_file)
    print(av_requests)
    
    
if __name__ == '__main__':
    speakers = ['Page', 'Jones', 'Bean', 'Zappala', 'Clement', 'Fulda']
    rooms = ['2233', '2228', '2230', '2242', '2220', '2238']
    desired_lineup = [('Fulda', '9am'), ('Page', '10am'), ('Jones', '11am'), ('Zappala', '12pm')]
    main(speakers, rooms, desired_lineup, sys.argv[1])
    
