def make_room_assignments(speakers, rooms):
    """
    Return a dictionary mapping each speaker to a room
    """
    assignments = {}
    for speaker, room in zip(speakers, rooms):
        assignments[speaker] = room
    return assignments


def main(speakers, rooms, desired_lineup):
    room_assignments = make_room_assignments(speakers, rooms)
    print("Speaker room assignments:")
    print(room_assignments)
    print()
    
    
if __name__ == '__main__':
    speakers = ['Page', 'Jones', 'Bean', 'Zappala', 'Clement', 'Fulda']
    rooms = ['2233', '2228', '2230', '2242', '2220', '2238']
    main(speakers, rooms)
    
