def make_itinerary(desired_speaker_times, room_assignments):
    """
    Input: list of (speaker, time) tuples
    Return a list of (speaker, room, time) tuples
    """
    itinerary = []
    for speaker, time in desired_speaker_times:
        itinerary.append((speaker, room_assignments[speaker], time))
    return itinerary


def make_room_assignments(speakers, rooms):
    """
    Return a dictionary mapping each speaker to a room
    """
    assignments = {}
    for speaker, room in zip(speakers, rooms):
        assignments[speaker] = room
    return assignments


def main(speakers, rooms, desired_lineup):
    room_assignments = make_room_assignments(speakers, rooms)
    print("Speaker room assignments:")
    print(room_assignments)
    print()
    
    print("Itinerary:")
    itinerary = make_itinerary(desired_lineup, room_assignments)
    print(itinerary)
    
    
    
if __name__ == '__main__':
    speakers = ['Page', 'Jones', 'Bean', 'Zappala', 'Clement', 'Fulda']
    rooms = ['2233', '2228', '2230', '2242', '2220', '2238']
    desired_lineup = [('Fulda', '9am'), ('Page', '10am'), ('Jones', '11am'), ('Zappala', '12pm')]
    main(speakers, rooms, desired_lineup)
    
