import sys
import string


def readfile(filename):
    with open(filename) as file:
        return file.read()
    
    
def count_words(content):
    """Count the number of each word in content. Ignore casing and punctuation."""
    counts = {}
    for word in content.lower().split():
        word = word.strip(string.punctuation)
        if word not in counts:
            counts[word] = 0
        counts[word] += 1
    return counts

        
def main(filename):
    content = readfile(filename)
    counts = count_words(content)
    print(counts)
    
    
if __name__ == '__main__':
    main(sys.argv[1])
    
