# Solution
from byubit import Bit


def go_left_up(bit):
    bit.turn_left()
    while bit.can_move_right():
        bit.move()
        bit.paint('green')
    bit.move()
    bit.turn_right()

    
def go_right_up(bit):
    bit.turn_right()
    while bit.can_move_left():
        bit.move()
        bit.paint('green')
    bit.move()
    bit.turn_left()

    
def go_up(bit):
    if bit.can_move_left():
        go_left_up(bit)
    else:
        go_right_up(bit)
        
        
@Bit.worlds('elevators', 'more-elevators')
def run(bit):
    while bit.can_move_front():
        bit.move()
        if bit.is_on_green():
            go_up(bit)
          
        
if __name__ == '__main__':
    run(Bit.new_bit)
