# Another hurdles solution
# This one is a little trickier than the first
# What happens when the order of if/else conditions is changed (i.e. the not front clear block comes first)?
# Which solution is easier to understand? This one or the other one? Which seems simpler?

from byubit import Bit


def jump(bit):
    bit.turn_left()
    while not bit.can_move_right():
        bit.move()
        bit.paint('green')
    bit.turn_right()
    bit.move()
    bit.paint('green')

    
def fall(bit):
    bit.turn_right()
    while bit.can_move_front():
        bit.move()
        bit.paint('green')
    bit.turn_left()
    
    
@Bit.run('hurdles', 'more-hurdles')
def run(bit):
    bit.paint('green')
    while bit.can_move_left():
        if bit.can_move_right():
            fall(bit)

        elif not bit.can_move_front():
            jump(bit)
        
        else:
            bit.move()
            bit.paint('green')
            

if __name__ == '__main__':
    run(Bit.new_bit)
    
