# solution
from byubit import Bit, use_text_renderer
use_text_renderer()


def is_finished(bit):
    return not bit.can_move_front() and not bit.can_move_left()


def go_green(bit):
    """
    Bit moves forward until blocked, painting green on the way
    The first square is not painted; the last square IS painted.
    """
    while bit.can_move_front():
        bit.move()
        bit.paint('green')

        
def cover_green(bit):
    """
    Bit moves forward until the right side is clear, painting green on the way
    The first square is not painted; the last square IS painted.
    """
    while not bit.can_move_right():
        bit.move()
        bit.paint('green')
              

def jump_hurdle(bit):
    """
    Bit starts at base of hurdle on left side facing right
    Bit ends at base of hurdle on right side facing right
    """
    # Up
    bit.turn_left()
    cover_green(bit)
    bit.turn_right()
    
    # Over
    bit.move()
    bit.paint('green')
    cover_green(bit)
    
    # Down
    bit.turn_right()
    go_green(bit)
    bit.turn_left()
    
    bit.snapshot('Hurdle cleared!')

    
@Bit.worlds('for_class/worlds/hurdles', 'for_class/worlds/more-hurdles')
def run(bit):
    bit.paint('green')
    while not is_finished(bit):
        if not bit.can_move_front():
            jump_hurdle(bit)
        else:
            bit.move()
            bit.paint('green')
            # go_green(bit)
            
            
if __name__ == '__main__':
    run(Bit.new_bit)
    
