def get_ingredient():
    ingredient = input('Ingredient: ')
    if not ingredient:
        return None
    quantity = float(input('Quantity: '))
    unit = input('Unit: ')
    return ingredient, quantity, unit


def get_ingredients():
    print('What ingredients are in your recipe?')
    recipe = []
    while True:
        item = get_ingredient()
        if item is None:
            break
        recipe.append(item)
    return recipe


def get_factor():
    return float(input('Scaling factor: '))
    
    
    
def scale_recipe(recipe, factor):
    new_recipe = []
    for ingredient, quantity, unit in recipe:
        new_item = (ingredient, quantity * factor, unit)
        new_recipe.append(new_item)
    return new_recipe


def print_recipe(recipe):
    print('New Recipe:')
    for ingredient, quantity, unit in recipe:
        print(f'  {quantity} ({unit}) {ingredient}')
        
        
def main():
    recipe = get_ingredients()
    factor = get_factor()
    recipe = scale_recipe(recipe, factor)
    print_recipe(recipe)


if __name__ == '__main__':
    main()
    
