from byubit import Bit



def get_next_color(bit):
    color = bit.get_color()
    bit.paint('white')
    bit.move()
    return color


def go(bit):
    """Go until blocked in front."""
    while bit.can_move_front():
        bit.move()


def go_to_start(bit):
    """Bit starts anywhere on the board and ends in the bottom left corner facing right."""
    bit.turn_left()
    bit.turn_left()
    go(bit)
    bit.turn_left()
    go(bit)
    bit.turn_left()
    

def paint_t(bit, color):
    """Paint a T. Start in the bottom left of the 3x3 box. End just outside the bottom right of the 3x3 box."""
    bit.move()
    bit.turn_left()
    bit.paint(color)
    bit.move()
    bit.paint(color)
    bit.move()
    bit.turn_left()
    bit.move()
    bit.turn_left()
    bit.turn_left()
    bit.paint(color)
    bit.move()
    bit.paint(color)
    bit.move()
    bit.paint(color)
    bit.turn_right()
    bit.move()
    bit.move()
    bit.turn_left()
    bit.move()
    bit.snapshot('T painted')
    

@Bit.worlds('color_tt', 'color_tt2')
def run(bit):
    # Get colors
    first_color = get_next_color(bit)
    second_color = get_next_color(bit)    
    third_color = get_next_color(bit)
    
    bit.snapshot('Got colors')
    
    go_to_start(bit)
    bit.snapshot('At start')
    
    paint_t(bit, first_color)
    paint_t(bit, second_color)
    paint_t(bit, third_color)
    

if __name__ == '__main__':
    run(Bit.new_bit)
