from byubit import Bit, use_text_renderer
use_text_renderer()

def go(bit):
    while bit.can_move_front():
        bit.move()


def get_ground_color(bit):
    # Set the marker
    bit.paint('blue')

    # Go to ground
    bit.turn_right()
    go(bit)

    # Get the ground color
    color = bit.get_color()
    bit.snapshot(color)

    # Go back to marker
    bit.turn_left()
    bit.turn_left()
    bit.move()
    while not bit.is_on_blue():
        bit.move()
    bit.turn_right()

    # Return the color
    return color


def paint_the_cloud(bit):
    color = get_ground_color(bit)
    bit.paint(color)
    bit.snapshot(color)


@Bit.worlds('for_class/worlds/sky', 'for_class/worlds/more-sky')
@Bit.pictures('images/', ext='svg', title='Sky')
def main(bit):
    while bit.can_move_front():
        paint_the_cloud(bit)
        bit.move()
    paint_the_cloud(bit)


if __name__ == '__main__':
    main(Bit.new_bit)
