#!/usr/bin/env python3

"""
based on code from Nick Parlante for Stanford CS106A
"""

from utilities import draw_grid_canvas, start_timer

import sys
import random
import drawcanvas
import tkinter

from byugrid import Grid


def random_right(grid):
    """
    Set 10% of the right grid column to random letters from the word 'cougars'
    :param grid: a grid
    :return: the same grid, but with random letters on the right edge
    """
    # loop through every row
    for y in range(grid.height):
        # one out of every 10 times through this loop:
        if random.randrange(10) == 0:
            # pick a random letter from 'cougars'
            char = random.choice('cougars')
            # set the cell at (grid.width - 1, y) to that letter
            grid.set(grid.width - 1, y, char)
    return grid


def scroll_left(grid):
    """
    Scroll all grid cells to the left
    """
    for y in range(grid.height):
        for x in range(grid.width):
            # get value at (x, y)
            value = grid.get(x, y)
            if value is not None and grid.in_bounds(x - 1, y):
                # move letter at (x, y) to the left
                grid.set(x - 1, y, value)
            # set old location to be empty
            grid.set(x, y, None)


# ************* Utility Functions Below here

def movie_action(grid, canvas):
    """ This function is called repeatedly by a timer.
    It creates letters randomly on the right, draws the canvas,
    then scrolls the letters left.
    """
    random_right(grid)
    draw_grid_canvas(grid, canvas, 10)
    scroll_left(grid)


def main():
    args = sys.argv[1:]

    width = 30
    height = 30

    # Can give width/height on command line
    if len(args) == 2:
        width = int(args[0])
        height = int(args[1])

    # create the grid
    grid = Grid(width, height)

    # draw the canvas
    canvas = drawcanvas.make_canvas(width * 10, height * 10, 'Movie')
    draw_grid_canvas(grid, canvas, 10)

    # start a timer that will call movie_action every 30ms
    start_timer(canvas, 10, lambda: movie_action(grid, canvas))

    # run the animation
    tkinter.mainloop()


if __name__ == '__main__':
    main()
